<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account-dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woothemes.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div class="myaccount">
	<div class="myaccount__flex clearfix">
		<div class="myaccount__avatar">
			<?php global $userdata; wp_get_current_user(); echo get_avatar( $userdata->ID, 128 ); ?>
		</div>
		<div class="myaccount__content">
			<?php
			printf(
				__( 'Bonjour <strong>%1$s</strong> (pas %1$s? <a href="%2$s">déconnexion</a>).', 'listable' ) . ' ',
				$current_user->display_name,
				wc_get_endpoint_url( 'customer-logout', '', wc_get_page_permalink( 'myaccount' ) )
			);

			printf( __( 'Depuis le tableau de bord de votre compte, vous pouvez consulter vos commandes, gérer vos adresses et <a href="%s"> éditer vos mots de pass et détails de votre compte</a>.', 'listable' ),
				wc_customer_edit_account_url()
			);
			?>
		</div>
	</div>
</div>

<p>
	<?php
	echo sprintf( esc_attr__( '', 'listable' ), '<a href="' . esc_url( wc_get_endpoint_url( 'orders' ) ) . '">', '</a>', '<a href="' . esc_url( wc_get_endpoint_url( 'edit-address' ) ) . '">', '<a href="' . esc_url( wc_get_endpoint_url( 'edit-account' ) ) . '">' );
	?>
</p>

<?php
/**
 * My Account dashboard.
 *
 * @since 2.6.0
 */
do_action( 'woocommerce_account_dashboard' );

/**
 * Deprecated woocommerce_before_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action( 'woocommerce_before_my_account' );

/**
 * Deprecated woocommerce_after_my_account action.
 *
 * @deprecated 2.6.0
 */
do_action( 'woocommerce_after_my_account' );
?>
