<?php

/*
Plugin Name: WP Kraken [#v206227]
Plugin URI: https://wpkraken.io/job/v206227
Description: Fix a bug between booked plugin and listable theme
Author: WP Kraken [Paulina]
Author URI: https://wpkraken.io/
Version: 1.0
Text Domain: wpk-v206227
*/

if ( ! class_exists( 'WPK_v206227' ) ) {

	class WPK_v206227 {
		/** @var string $slug Contains plugin text domain */
		public $slug = 'wpk-v206227';
		/** @var string $plugin_path Path to plugin directory */
		public $plugin_path = '';
		/** @var string $plugin_url URL address to plugin directory */
		public $plugin_url = '';

		/**
		 * WPK_v206227 constructor.
		 */
		public function __construct() {
			if ( empty( $this->plugin_path ) ) {
				$this->plugin_path = plugin_dir_path( __FILE__ );
			}

			if ( empty( $this->plugin_url ) ) {
				$this->plugin_url = plugin_dir_url( __FILE__ );
			}

			/* Registers */
			add_action( 'init', array( $this, 'init' ), 100 );
		}

		/**
		 * Perform an initialization
		 */
		function init() {
			/* Registers */
			add_action( 'wp_enqueue_scripts', array( $this, 'register_scripts' ) );
		}


		/**
		 * Register Front End scripts and styles
		 */
		function register_scripts() {
			wp_enqueue_script( $this->slug, $this->plugin_url . 'main-v4.js', array( 'jquery' ), null, true );
			wp_enqueue_style( $this->slug, $this->plugin_url . 'main-v3.css', array(), null );
		}
	}
}

new WPK_v206227();