if(!CodeMirror.modeExtensions)CodeMirror.modeExtensions={};CodeMirror.defineExtension("getModeExt",function(){var mname=CodeMirror.resolveMode(this.getOption("mode")).name;var ext=CodeMirror.modeExtensions[mname];if(!ext)throw new Error("No extensions found for mode "+mname);return ext;});CodeMirror.defineExtension("getModeExtAtPos",function(pos){var token=this.getTokenAt(pos);if(token&&token.state&&token.state.mode)
return CodeMirror.modeExtensions[token.state.mode=="html"?"htmlmixed":token.state.mode];else
return this.getModeExt();});CodeMirror.defineExtension("commentRange",function(isComment,from,to){var curMode=this.getModeExtAtPos(this.getCursor());if(isComment){var commentedText=this.getRange(from,to);this.replaceRange(curMode.commentStart+this.getRange(from,to)+curMode.commentEnd,from,to);if(from.line==to.line&&from.ch==to.ch){this.setCursor(from.line,from.ch+curMode.commentStart.length);}}
else{var selText=this.getRange(from,to);var startIndex=selText.indexOf(curMode.commentStart);var endIndex=selText.lastIndexOf(curMode.commentEnd);if(startIndex>-1&&endIndex>-1&&endIndex>startIndex){selText=selText.substr(0,startIndex)
+selText.substring(startIndex+curMode.commentStart.length,endIndex)
+selText.substr(endIndex+curMode.commentEnd.length);}
this.replaceRange(selText,from,to);}});CodeMirror.defineExtension("autoIndentRange",function(from,to){var cmInstance=this;this.operation(function(){for(var i=from.line;i<=to.line;i++){cmInstance.indentLine(i,"smart");}});});CodeMirror.defineExtension("autoFormatRange",function(from,to){var absStart=this.indexFromPos(from);var absEnd=this.indexFromPos(to);var res=this.getModeExt().autoFormatLineBreaks(this.getValue(),absStart,absEnd);var cmInstance=this;this.operation(function(){cmInstance.replaceRange(res,from,to);var startLine=cmInstance.posFromIndex(absStart).line;var endLine=cmInstance.posFromIndex(absStart+res.length).line;for(var i=startLine;i<=endLine;i++){cmInstance.indentLine(i,"smart");}});});CodeMirror.modeExtensions["css"]={commentStart:"/*",commentEnd:"*/",wordWrapChars:[";","\\{","\\}"],autoFormatLineBreaks:function(text,startPos,endPos){text=text.substring(startPos,endPos);return text.replace(new RegExp("(;|\\{|\\})([^\r\n])","g"),"$1\n$2");}};CodeMirror.modeExtensions["javascript"]={commentStart:"/*",commentEnd:"*/",wordWrapChars:[";","\\{","\\}"],getNonBreakableBlocks:function(text){var nonBreakableRegexes=[new RegExp("for\\s*?\\(([\\s\\S]*?)\\)"),new RegExp("'([\\s\\S]*?)('|$)"),new RegExp("\"([\\s\\S]*?)(\"|$)"),new RegExp("//.*([\r\n]|$)")];var nonBreakableBlocks=new Array();for(var i=0;i<nonBreakableRegexes.length;i++){var curPos=0;while(curPos<text.length){var m=text.substr(curPos).match(nonBreakableRegexes[i]);if(m!=null){nonBreakableBlocks.push({start:curPos+m.index,end:curPos+m.index+m[0].length});curPos+=m.index+Math.max(1,m[0].length);}
else{break;}}}
nonBreakableBlocks.sort(function(a,b){return a.start-b.start;});return nonBreakableBlocks;},autoFormatLineBreaks:function(text,startPos,endPos){text=text.substring(startPos,endPos);var curPos=0;var reLinesSplitter=new RegExp("(;|\\{|\\})([^\r\n])","g");var nonBreakableBlocks=this.getNonBreakableBlocks(text);if(nonBreakableBlocks!=null){var res="";for(var i=0;i<nonBreakableBlocks.length;i++){if(nonBreakableBlocks[i].start>curPos){res+=text.substring(curPos,nonBreakableBlocks[i].start).replace(reLinesSplitter,"$1\n$2");curPos=nonBreakableBlocks[i].start;}
if(nonBreakableBlocks[i].start<=curPos&&nonBreakableBlocks[i].end>=curPos){res+=text.substring(curPos,nonBreakableBlocks[i].end);curPos=nonBreakableBlocks[i].end;}}
if(curPos<text.length-1){res+=text.substr(curPos).replace(reLinesSplitter,"$1\n$2");}
return res;}
else{return text.replace(reLinesSplitter,"$1\n$2");}}};CodeMirror.modeExtensions["xml"]={commentStart:"<!--",commentEnd:"-->",wordWrapChars:[">"],autoFormatLineBreaks:function(text,startPos,endPos){text=text.substring(startPos,endPos);var lines=text.split("\n");var reProcessedPortion=new RegExp("(^\\s*?<|^[^<]*?)(.+)(>\\s*?$|[^>]*?$)");var reOpenBrackets=new RegExp("<","g");var reCloseBrackets=new RegExp("(>)([^\r\n])","g");for(var i=0;i<lines.length;i++){var mToProcess=lines[i].match(reProcessedPortion);if(mToProcess!=null&&mToProcess.length>3){lines[i]=mToProcess[1]
+mToProcess[2].replace(reOpenBrackets,"\n$&").replace(reCloseBrackets,"$1\n$2")
+mToProcess[3];continue;}}
return lines.join("\n");}};CodeMirror.modeExtensions["htmlmixed"]={commentStart:"<!--",commentEnd:"-->",wordWrapChars:[">",";","\\{","\\}"],getModeInfos:function(text,absPos){var modeInfos=new Array();modeInfos[0]={pos:0,modeExt:CodeMirror.modeExtensions["xml"],modeName:"xml"};var modeMatchers=new Array();modeMatchers[0]={regex:new RegExp("<style[^>]*>([\\s\\S]*?)(</style[^>]*>|$)","i"),modeExt:CodeMirror.modeExtensions["css"],modeName:"css"};modeMatchers[1]={regex:new RegExp("<script[^>]*>([\\s\\S]*?)(</script[^>]*>|$)","i"),modeExt:CodeMirror.modeExtensions["javascript"],modeName:"javascript"};var lastCharPos=(typeof(absPos)!=="undefined"?absPos:text.length-1);for(var i=0;i<modeMatchers.length;i++){var curPos=0;while(curPos<=lastCharPos){var m=text.substr(curPos).match(modeMatchers[i].regex);if(m!=null){if(m.length>1&&m[1].length>0){var blockBegin=curPos+m.index+m[0].indexOf(m[1]);modeInfos.push({pos:blockBegin,modeExt:modeMatchers[i].modeExt,modeName:modeMatchers[i].modeName});modeInfos.push({pos:blockBegin+m[1].length,modeExt:modeInfos[0].modeExt,modeName:modeInfos[0].modeName});curPos+=m.index+m[0].length;continue;}
else{curPos+=m.index+Math.max(m[0].length,1);}}
else{break;}}}
modeInfos.sort(function sortModeInfo(a,b){return a.pos-b.pos;});return modeInfos;},autoFormatLineBreaks:function(text,startPos,endPos){var modeInfos=this.getModeInfos(text);var reBlockStartsWithNewline=new RegExp("^\\s*?\n");var reBlockEndsWithNewline=new RegExp("\n\\s*?$");var res="";if(modeInfos.length>1){for(var i=1;i<=modeInfos.length;i++){var selStart=modeInfos[i-1].pos;var selEnd=(i<modeInfos.length?modeInfos[i].pos:endPos);if(selStart>=endPos){break;}
if(selStart<startPos){if(selEnd<=startPos){continue;}
selStart=startPos;}
if(selEnd>endPos){selEnd=endPos;}
var textPortion=text.substring(selStart,selEnd);if(modeInfos[i-1].modeName!="xml"){if(!reBlockStartsWithNewline.test(textPortion)&&selStart>0){textPortion="\n"+textPortion;}
if(!reBlockEndsWithNewline.test(textPortion)&&selEnd<text.length-1){textPortion+="\n";}}
res+=modeInfos[i-1].modeExt.autoFormatLineBreaks(textPortion);}}
else{res=modeInfos[0].modeExt.autoFormatLineBreaks(text.substring(startPos,endPos));}
return res;}};